/**
 * 
 */
package gov.va.med.mhv.usermgmt.test.builder;

import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.service.ServiceResponse;
import org.tigris.atlas.transfer.BaseTO;


/**
 * @author Rob Proper
 *
 */
public class MessageHandler {
	
	private static final Log LOG = LogFactory.getLog(MessageHandler.class);

	private MessageHandler() {
	}

	public static void handleMessages(ServiceResponse response, 
		BaseTO transferObject, String message) 
	{
		handleMessages(response, message);
		handleMessages(transferObject, message);
	}

	public static void handleMessages(ServiceResponse response, 
		String message) 
	{
		handleMessages(response, message, null);
	}
	
	public static void handleMessages(ServiceResponse response, 
		String message, LogLevel level) 
	{
		handleMessages(response.getMessages(), message, level);
	}

	public static void handleMessages(BaseTO transferObject, String message) {
		handleMessages(transferObject.getMessages(), message, null);
	}

	public static void handleMessages(Messages messages, String message, 
		LogLevel level) 
	{
		if (messages != null) {
			if (messages.hasErrorMessages()) {
				message = ((StringUtils.isBlank(message)) ? "" : message + ": ") 
					+ messages.getErrorMessages();
				if (level != null) {
					log(level, message);
				} else {
					throw new IllegalStateException(message);
				}
			} 
			if (messages.hasInformationalMessages()) {
				log(LogLevel.Info, "" + messagesToString(messages.
					getInformationalMessages()));
			}
		}
	}
	
	private static String messagesToString(Collection messages) {
		StringBuilder str = new StringBuilder();
		for (Iterator i = messages.iterator(); i.hasNext();) {
			Message message = (Message) i.next();
			str.append(message.getKey());
			if (message.getInserts().size() > 0) {
				str.append("; inserts=[").append(message.getInserts()).
					append("]");
			}
			if (message.getProperties().size() > 0) {
				str.append("; properties=[").append(message.getProperties()).
					append("]");
			}
		}
		return str.toString();
	}
	
	private static void log(LogLevel level, String message) { 
		switch (level) { 
			case Fatal : LOG.fatal(message); break; 
			case Error : LOG.error(message); break;
			case Warn  : LOG.warn(message);  break;
			case Info  : LOG.info(message);  break;
			case Debug : LOG.debug(message);  break;
			default: 
				// ignore
		}
	}

}
